#include "c4d_gedata.h"
#include "ge_vector.h"
#include "c4d_string.h"
#include "c4d_memory.h"
#include "c4d_basecontainer.h"
#include "ge_matrix.h"
#include "c4d_file.h"
#include "c4d_baselist.h"

GeData::GeData(void)
{
	Type=DA_NIL;
	DInteger = 0;
}

GeData::GeData(int n)
{
	Type=DA_LONG;
	DInteger = n;
}

GeData::GeData(LONG n)
{
	Type=DA_LONG;
	DInteger = n;
}

GeData::GeData(Real n)
{
	Type=DA_REAL;
	DReal=n;
}

GeData::GeData(double n)
{
	Type=DA_REAL;
	DReal=(Real)n;
}

GeData::GeData(const Vector& n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetVector(this,n);
}

GeData::GeData(const String &n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetString(this,&n);
}

GeData::GeData(const BaseContainer &n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetBaseContainer(this,&n);
}

GeData::GeData(const Matrix &n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetMatrix(this,n);
}

GeData::GeData(const Filename &n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetFilename(this,&n);
}

GeData::GeData(const BaseTime &n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetBaseTime(this,n);
}

GeData::GeData(const GeData& n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->CopyData(this,&n,NULL);
}

GeData::GeData(const BaseLink &n)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetLink(this,n);
}

GeData::GeData(LONG type,const CustomDataType &data)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->SetCustomData(this,type,data);
}

GeData::GeData(LONG type,DEFAULTVALUETYPE v)
{
	Type=DA_NIL;
	Ddata=NULL;
	C4DOS.Gd->InitCustomData(this,type);
}

Bool GeData::operator == (const GeData &d) const
{
	return C4DOS.Gd->IsEqual(this,&d);
}

Bool GeData::operator != (const GeData &d) const
{
	return !C4DOS.Gd->IsEqual(this,&d);
}

void GeData::CopyData(GeData *dest,AliasTrans *aliastrans) const
{
	C4DOS.Gd->CopyData(dest,this,aliastrans);
}

const GeData& GeData::operator = (const GeData &n)
{
	n.CopyData(this,NULL);
	return *this;
}

void GeData::Free(void)
{
	C4DOS.Gd->Free(this);
}

GeData::~GeData(void)
{
	C4DOS.Gd->Free(this);
}

GeDataType GeData::GetType(void) const
{
	return (GeDataType)C4DOS.Gd->GetType(this);
}

LONG GeData::GetLong(void) const
{
	return C4DOS.Gd->GetLong(this);
}

Real GeData::GetReal(void) const
{
	return C4DOS.Gd->GetReal(this);
}

const Vector &GeData::GetVector(void) const
{
	return C4DOS.Gd->GetVector(this);
}

const String& GeData::GetString(void) const
{
	return C4DOS.Gd->GetString(this);
}

BaseContainer* GeData::GetContainer(void) const
{
	return C4DOS.Gd->GetContainer(this);
}

const Matrix &GeData::GetMatrix(void) const
{
	return C4DOS.Gd->GetMatrix(this);
}

const Filename& GeData::GetFilename(void) const
{
	return C4DOS.Gd->GetFilename(this);
}

const BaseTime &GeData::GetTime(void) const
{
	return C4DOS.Gd->GetTime(this);
}

BaseLink *GeData::GetBaseLink(void) const
{
	return C4DOS.Gd->GetLink(this);
}

BaseList2D *GeData::GetLink(BaseDocument *doc, LONG instanceof) const
{
	BaseLink *link=C4DOS.Gd->GetLink(this);
	if (!link) return NULL;
	return link->GetLink(doc,instanceof);
}

CustomDataType*	GeData::GetCustomDataType	(LONG datatype) const
{
	return C4DOS.Gd->GetCustomData(this,datatype);
}

BrowseContainer::BrowseContainer(const BaseContainer *bc)
{
	t_bc		= (BaseContainer*)bc;
	handle	= C4DOS.Bc->BrowseContainer(t_bc,NULL,NULL,NULL);
}

void BrowseContainer::Reset(void)
{
	handle	= C4DOS.Bc->BrowseContainer(t_bc,NULL,NULL,NULL);
}

Bool BrowseContainer::GetNext(LONG *id,GeData **data)
{
	if (!handle) return FALSE;
	handle = C4DOS.Bc->BrowseContainer(t_bc,id,data,handle);
	return TRUE;
}
